/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#if 0
/* two procs only: single-writer into peer queue: no atomic operation needed */
static inline uint32_t mx__cmpswap_u32(uint32_t *ptr, uint32_t old, uint32_t new)
{
  uint32_t ret;
  ret = *ptr;
  if (*ptr == old)
    *ptr = new;
  return ret;
}
#elif MX_CPU_x86  || MX_CPU_x86_64

#ifdef __GNUC__
static inline uint32_t mx__cmpswap_u32(uint32_t *ptr, uint32_t old, uint32_t new)
{
  asm volatile("lock\n\tcmpxchgl %1,%2" : "=a" (old) : "q" (new), "m" (*ptr),"0" (old) : "memory");
  return old;
}
#elif MX_OS_SOLARIS

#include <atomic.h>

#define mx__cmpswap_u32 atomic_cas_32

#else
#error mx__cmpswap_u32 not supported here
#endif


#elif MX_CPU_powerpc || MX_CPU_powerpc64
static inline uint32_t mx__cmpswap_u32(uint32_t *ptr, uint32_t old, uint32_t new)
{
  uint32_t ret;
  asm volatile (
	   "0:    lwarx %0,0,%1 ;\n"
	   "      cmpw  0,%0,%2 ;\n"
	   "      bne 1f;\n"
	   "      stwcx. %3,0,%1;\n"
	   "      bne- 0b;\n"
	   "1:    isync;\n"
	: "=&r"(ret)
	: "r"(ptr), "r"(old), "r"(new)
	: "cr0", "memory");
  return ret;
}

#elif MX_CPU_ia64

static inline uint32_t mx__cmpswap_u32(uint32_t *ptr, uint32_t old, uint32_t new)
{
  uint32_t ret;
  uint64_t old64;
  asm volatile ("mov ar.ccv=%1;;"
		"cmpxchg4.rel %0=[%2],%3,ar.ccv"
                                  : "=r"(ret) : "r" (old), "r"(ptr), "r"(new) : "memory");
  return ret;
}

#elif MX_CPU_sparc || MX_CPU_sparc64

#include <atomic.h>
#define mx__cmpswap_u32 atomic_cas_32

#else

#error needs cmpxchg 

#endif

